
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Grape_Production")

# Create decision variables
R = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Red_Grapes")
G = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Green_Grapes")

# Set objective function
m.setObjective(300 * R + 250 * G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(R + G <= 100, "Land_Constraint")
m.addConstr(R >= 30, "Min_Red")
m.addConstr(G >= 25, "Min_Green")
m.addConstr(G <= 2 * R, "Green_Red_Ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Red Grapes: {R.x} acres")
    print(f"Green Grapes: {G.x} acres")
    print(f"Total Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

