
from gurobipy import *

# Create a new model
m = Model("Vine_Farmer_Problem")

# Define variables
R = m.addVar(name="Red_Grapes", lb=30)  # Acres for red grapes, minimum 30 acres
G = m.addVar(name="Green_Grapes", lb=25)  # Acres for green grapes, minimum 25 acres

# Set the objective function: Maximize profit
m.setObjective(300*R + 250*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(R + G <= 100, name="Total_Land")  # Total land constraint
m.addConstr(G <= 2*R, name="Green_vs_Red")  # Green grapes at most twice the red

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {R.varName} = {R.x}, {G.varName} = {G.x}")
    print(f"Maximum Profit: ${300*R.x + 250*G.x}")
else:
    print("No optimal solution found")
