
import gurobi

def solve_grape_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    R = m.addVar(lb=0, name="Red_Grapes")
    G = m.addVar(lb=0, name="Green_Grapes")

    # Objective function: Maximize profit
    m.setObjective(300*R + 250*G, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(R >= 30, name="Min_Red")
    m.addConstr(G >= 25, name="Min_Green")
    m.addConstr(G <= 2*R, name="Green_vs_Red")
    m.addConstr(R + G <= 100, name="Total_Land")

    # Solve the problem
    m.optimize()

    # Check if the model is optimized
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Acres of Red Grapes: {R.varValue}")
        print(f"Acres of Green Grapes: {G.varValue}")
        print(f"Max Profit: {m.objVal}")
    else:
        print("The model is infeasible")

solve_grape_problem()
