
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("cream_mixing")

# Create decision variables
alpha = model.addVar(lb=0, name="alpha")
beta = model.addVar(lb=0, name="beta")

# Set objective function
model.setObjective(0.70 * alpha + 0.90 * beta, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * alpha + 4.1 * beta >= 4, "compound_x")
model.addConstr(2.7 * alpha + 3.2 * beta >= 8, "compound_y")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Cream Alpha: {alpha.x:.2f} mg")
    print(f"Cream Beta: {beta.x:.2f} mg")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

