
from gurobipy import *

# Create a new model
m = Model("Kappa_Medical")

# Define the decision variables
x_A = m.addVar(name='x_A', lb=0)  # Amount of cream Alpha
x_B = m.addVar(name='x_B', lb=0)  # Amount of cream Beta

# Set the objective function: minimize the total cost
m.setObjective(0.70*x_A + 0.90*x_B, GRB.MINIMIZE)

# Add constraints for compound X and Y requirements
m.addConstr(2*x_A + 4.1*x_B >= 4, name='compound_X')
m.addConstr(2.7*x_A + 3.2*x_B >= 8, name='compound_Y')

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount of cream Alpha: {x_A.x} mg")
    print(f"Amount of cream Beta: {x_B.x} mg")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
