
import gurobi

def solve_kappa_medical_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="cream_alpha", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="cream_beta", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize cost
    model.setObjective(0.70 * x + 0.90 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x + 4.1 * y >= 4, name="compound_x_constraint")
    model.addConstr(2.7 * x + 3.2 * y >= 8, name="compound_y_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal cost: ", model.objVal)
        print("Amount of cream Alpha: ", x.varValue)
        print("Amount of cream Beta: ", y.varValue)
    else:
        print("The problem is infeasible")

solve_kappa_medical_problem()
