
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("CandyMixture")

# Create decision variables
x = model.addVar(lb=0, name="Mixture_A")  # Kilograms of mixture A
y = model.addVar(lb=0, name="Mixture_B")  # Kilograms of mixture B

# Set objective function
model.setObjective(30*x + 40*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.75*x + 0.40*y <= 30, "GummyBears")
model.addConstr(0.25*x + 0.60*y <= 25, "GummyWorms")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Mixture A (kg): {x.x}")
    print(f"Mixture B (kg): {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

