
from gurobipy import *

# Create a model
m = Model("Gummy_Mixtures")

# Define decision variables
x = m.addVar(lb=0, name="Mixture_A")
y = m.addVar(lb=0, name="Mixture_B")

# Objective function: Maximize profit
m.setObjective(30*x + 40*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(0.75*x + 0.40*y <= 30, "Gummy_Bears_Constraint")
m.addConstr(0.25*x + 0.60*y <= 25, "Gummy_Worms_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
