
import gurobi

def solve_candy_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_A = model.addVar(name="x_A", lb=0, ub=None, obj=30)  # Mixture A
    x_B = model.addVar(name="x_B", lb=0, ub=None, obj=40)  # Mixture B

    # Gummy bears constraint
    model.addConstr(0.75 * x_A + 0.40 * x_B <= 30, name="gummy_bears")

    # Gummy worms constraint
    model.addConstr(0.25 * x_A + 0.60 * x_B <= 25, name="gummy_worms")

    # Set the objective to maximize profit
    model.setObjective(30 * x_A + 40 * x_B, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Mixture A: {x_A.x}, Mixture B: {x_B.x}")
        print(f"Maximum profit: ${30 * x_A.x + 40 * x_B.x:.2f}")
    else:
        print("No optimal solution found.")

solve_candy_store_problem()
