
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("SupplementOptimization")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="x") # Servings of supplement A
y = model.addVar(vtype=GRB.CONTINUOUS, name="y") # Servings of supplement B


# Set objective function
model.setObjective(2*x + 4*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(x + 4*y >= 12, "KeratinRequirement")
model.addConstr(5*x + y >= 20, "CalciumRequirement")
model.addConstr(x >= 0, "NonNegativityX")
model.addConstr(y >= 0, "NonNegativityY")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal:.2f}")
    print(f"Servings of Supplement A: {x.x:.2f}")
    print(f"Servings of Supplement B: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

