
from gurobipy import *

# Create a new model
m = Model("Supplement_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="supplement_A", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="supplement_B", lb=0)

# Set the objective function
m.setObjective(2*x + 4*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + 4*y >= 12, "keratin_constraint")
m.addConstr(5*x + y >= 20, "calcium_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Supplement A servings: {x.x}")
    print(f"Supplement B servings: {y.x}")
    print(f"Total cost: ${2*x.x + 4*y.x:.2f}")
else:
    print("No optimal solution found.")

