
import gurobi

def solve_supplement_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="servings_of_supplement_A")
    y = model.addVar(lb=0, name="servings_of_supplement_B")

    # Define the objective function
    model.setObjective(2*x + 4*y, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(x + 4*y >= 12, name="keratin_requirement")
    model.addConstr(5*x + y >= 20, name="calcium_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal servings of supplement A: {x.varValue}")
        print(f"Optimal servings of supplement B: {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The problem is infeasible.")

solve_supplement_problem()
