
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("water_sports")

# Create decision variables
r = m.addVar(vtype=GRB.INTEGER, name="rafts")
k = m.addVar(vtype=GRB.INTEGER, name="kayaks")

# Set objective function
m.setObjective(45 * r + 55 * k, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * r + 12 * k <= 400, "space_constraint")
m.addConstr(200 * r + 250 * k <= 10000, "budget_constraint")
m.addConstr(r >= 0.55 * (r + k), "raft_proportion")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Rafts: {r.x}")
    print(f"Number of Kayaks: {k.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

