
from gurobipy import *

# Create a model
m = Model("Sports_Warehouse_Optimization")

# Define decision variables
R = m.addVar(vtype=GRB.INTEGER, name="Rafts")
K = m.addVar(vtype=GRB.INTEGER, name="Kayaks")

# Objective function: Maximize profit
m.setObjective(45*R + 55*K, GRB.MAXIMIZE)

# Constraints
m.addConstr(10*R + 12*K <= 400, "Space_Constraint")
m.addConstr(200*R + 250*K <= 10000, "Budget_Constraint")

# Ensure at least 55% of items are rafts
m.addConstr(R >= 0.55*(R + K), "Raft_Percentage_Constraint")

# Solve the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective (Max Profit): {m.objVal}")

