
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
R = m.addVar(name="Rafts", lb=0, vtype=gurobi.GRB.INTEGER)
K = m.addVar(name="Kayaks", lb=0, vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(45*R + 55*K, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*R + 12*K <= 400, name="Space_Constraint")
m.addConstr(200*R + 250*K <= 10000, name="Budget_Constraint")
m.addConstr(R >= 0.55*(R + K), name="Product_Mix_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Rafts: {R.varValue:.0f}")
    print(f"Kayaks: {K.varValue:.0f}")
    print(f"Max Profit: {m.objVal:.2f}")
else:
    print("No optimal solution found.")
