
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="donuts")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pastries")

# Set objective function
model.setObjective(2*x + 4*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + 5*y <= 10000, "baking_constraint")
model.addConstr(3*x + 2*y <= 7000, "stuffing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of donuts to make: {x.x}")
    print(f"Number of pastries to make: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

