
from gurobipy import *

# Create a model
m = Model("Bakery_Optimization")

# Define decision variables
D = m.addVar(lb=0, vtype=GRB.INTEGER, name="Donuts")
P = m.addVar(lb=0, vtype=GRB.INTEGER, name="Pastries")

# Objective function: Maximize profit
m.setObjective(2*D + 4*P, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*D + 5*P <= 10000, "Baking_Machine_Constraint")
m.addConstr(3*D + 2*P <= 7000, "Stuffing_Machine_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Donuts: {D.x}")
    print(f"Pastries: {P.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
