
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x_d = model.addVar(lb=0, name="donuts")
x_p = model.addVar(lb=0, name="pastries")

# Define the objective function
model.setObjective(2 * x_d + 4 * x_p, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(2 * x_d + 5 * x_p <= 10000, name="baking_machine")
model.addConstr(3 * x_d + 2 * x_p <= 7000, name="stuffing_machine")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of donuts: {x_d.varValue}")
    print(f"Number of pastries: {x_p.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
