
import gurobipy as gp

# Create a new model
model = gp.Model("GroceryOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="nuts")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="candy")

# Set objective function
model.setObjective(5*x + 3*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 5*y <= 1000, "weighing_time")
model.addConstr(5*x + 8*y <= 1500, "packaging_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of nut containers: {x.x:.2f}")
    print(f"Number of candy containers: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

