
from gurobipy import *

# Create a model
m = Model("Grocery_Optimization")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="nuts")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="candy")

# Set the objective function to maximize profit
m.setObjective(5*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 5*y <= 1000, "weighing_time")
m.addConstr(5*x + 8*y <= 1500, "packaging_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Containers of nuts: {x.x}")
    print(f"Containers of candy: {y.x}")
    print(f"Total profit: ${5*x.x + 3*y.x:.2f}")
else:
    print("No optimal solution found")
