
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="nuts")  # number of containers of nuts
    y = model.addVar(lb=0, name="candy")  # number of containers of candy

    # Define the objective function
    model.setObjective(5 * x + 3 * y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(10 * x + 5 * y <= 1000, name="weighing_time")
    model.addConstr(5 * x + 8 * y <= 1500, name="packaging_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of containers of nuts: {x.varValue}")
        print(f"Number of containers of candy: {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization problem
solve_optimization_problem()
