
import gurobipy as gp

# Create a new model
model = gp.Model("Nutrition_Optimization")

# Create decision variables
x = model.addVar(lb=0, name="carrots")  # Cups of carrots
y = model.addVar(lb=0, name="spinach") # Cups of spinach

# Set objective function
model.setObjective(5*x + 3*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(x + 2*y >= 20, "Biotin_req")
model.addConstr(3*x + 1.5*y >= 20, "Folate_req")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Cups of carrots: {x.x:.2f}")
    print(f"Cups of spinach: {y.x:.2f}")
else:
    print("Infeasible or unbounded solution.")

