
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="carrots", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="spinach", lb=0)

# Set the objective function
m.setObjective(5*x + 3*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + 2*y >= 20, "biotin_requirement")
m.addConstr(3*x + 1.5*y >= 20, "folate_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrots: {x.x} cups")
    print(f"Spinach: {y.x} cups")
    print(f"Total Cost: ${5*x.x + 3*y.x:.2f}")
else:
    print("No optimal solution found.")
