
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, name="carrots")  # cups of carrots
    y = model.addVar(lb=0, name="spinach")  # cups of spinach

    # Define the objective function
    model.setObjective(5*x + 3*y, gurobi.GRB.MINIMIZE)

    # Add biotin requirement constraint
    model.addConstr(x + 2*y >= 20, name="biotin_requirement")

    # Add folate requirement constraint
    model.addConstr(3*x + 1.5*y >= 20, name="folate_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Carrots: {x.varValue}, Spinach: {y.varValue}")
    else:
        print("No optimal solution found.")

# Run the optimization problem
solve_optimization_problem()
