
import gurobipy as gp

# Create a new model
model = gp.Model("SandwichOptimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="meatball_sandwiches")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")


# Set objective function
model.setObjective(3*x + 3.5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25*x + 30*y <= 4000, "meat_constraint")
model.addConstr(10*x + 25*y <= 5000, "cheese_constraint")
model.addConstr(50*x + 20*y <= 5200, "sauce_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Meatball Sandwiches: {x.x}")
    print(f"Ham Sandwiches: {y.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

