
from gurobipy import *

# Create a new model
m = Model("Sandwich_Optimization")

# Define the decision variables
x = m.addVar(name="meatball_sandwiches", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="ham_sandwiches", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(3*x + 3.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x + 30*y <= 4000, name="meat_constraint")
m.addConstr(10*x + 25*y <= 5000, name="cheese_constraint")
m.addConstr(50*x + 20*y <= 5200, name="sauce_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Total Profit: ${3*x.x + 3.5*y.x:.2f}")
else:
    print("No optimal solution found")
