
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x1 = m.addVar(lb=0, name="meatball_sandwiches")
x2 = m.addVar(lb=0, name="ham_sandwiches")

# Define the objective function
m.setObjective(3 * x1 + 3.50 * x2, gurobi.GRB.MAXIMIZE)

# Add the constraints
m.addConstr(25 * x1 + 30 * x2 <= 4000, name="meat_constraint")
m.addConstr(10 * x1 + 25 * x2 <= 5000, name="cheese_constraint")
m.addConstr(50 * x1 + 20 * x2 <= 5200, name="sauce_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Meatball sandwiches: {x1.varValue}")
    print(f"Ham sandwiches: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
