
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hot_sauce_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="large_bottles") # Number of large bottles
y = m.addVar(vtype=GRB.INTEGER, name="small_bottles") # Number of small bottles

# Set objective function
m.setObjective(5*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 2*y <= 1000, "budget_constraint")
m.addConstr(2*x + y <= 500, "shelf_space_constraint")
m.addConstr(y >= 0.5*(x + y), "proportion_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large bottles (x): {x.x}")
    print(f"Number of small bottles (y): {y.x}")
    print(f"Optimal Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

