
from gurobipy import *

# Create a new model
m = Model("Hot_Sauce_Optimization")

# Define the decision variables
L = m.addVar(name="Large_Bottles", vtype=GRB.INTEGER, lb=0)
S = m.addVar(name="Small_Bottles", vtype=GRB.INTEGER, lb=0)

# Set the objective function: Maximize profit
m.setObjective(5*L + 3*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*L + 2*S <= 1000, name="Budget_Constraint")
m.addConstr(2*L + S <= 500, name="Shelf_Space_Constraint")
m.addConstr(S >= L, name="Small_Bottles_Percentage_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Large Bottles: {L.x}")
    print(f"Number of Small Bottles: {S.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
