
import gurobipy as gp

# Create a new model
model = gp.Model("HotSauceInventory")

# Define variables
L = model.addVar(name="Large_Bottles", lb=0, vtype=gp.GRB.INTEGER)
S = model.addVar(name="Small_Bottles", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(5*L + 3*S, gp.GRB.MAXIMIZE)

# Budget constraint
model.addConstr(3*L + 2*S <= 1000, name="Budget_Constraint")

# Shelf space constraint
model.addConstr(2*L + S <= 500, name="Shelf_Space_Constraint")

# Product mix constraint
model.addConstr(S >= L, name="Product_Mix_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Large bottles: {L.varValue}, Small bottles: {S.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
