
import gurobipy as gp

# Create a new model
model = gp.Model("Advertising Optimization")

# Create variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="search_engine_ads")
y = model.addVar(vtype=gp.GRB.INTEGER, name="video_ads")
z = model.addVar(vtype=gp.GRB.INTEGER, name="social_media_ads")

# Set objective function
model.setObjective(100000*x + 7000*y + 800*z, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(50000*x + 5000*y + 1000*z <= 850000, "budget_constraint")
model.addConstr(y <= 4, "video_ad_limit")
model.addConstr(z <= 0.5 * (x + y + z), "social_media_proportion")
model.addConstr(x >= 0.1 * (x + y + z), "search_engine_proportion")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Influence: {model.objVal}")
    print(f"Number of Search Engine Ads: {x.x}")
    print(f"Number of Video Ads: {y.x}")
    print(f"Number of Social Media Ads: {z.x}")
else:
    print("No solution found.")

