
from gurobipy import *

# Create a model
m = Model("Tutoring_Company_Advertisement")

# Define decision variables
x1 = m.addVar(name='search_engine_ads', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='video_ads', vtype=GRB.INTEGER, lb=0)
x3 = m.addVar(name='social_media_ads', vtype=GRB.INTEGER, lb=0)

# Define the objective function
m.setObjective(100000*x1 + 7000*x2 + 800*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50000*x1 + 5000*x2 + 1000*x3 <= 850000, name='cost_constraint')
m.addConstr(x2 <= 4, name='video_ad_limit')
m.addConstr(x3 <= 0.5*(x1 + x2 + x3), name='social_media_proportion')
m.addConstr(x1 >= 0.1*(x1 + x2 + x3), name='search_engine_proportion')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Search Engine Ads: {x1.x}")
    print(f"Video Ads: {x2.x}")
    print(f"Social Media Ads: {x3.x}")
    print(f"Total Influence: {m.objVal}")
else:
    print("No optimal solution found")
