
import gurobipy as gp

# Create a new model
m = gp.Model("advertisements")

# Variables
x1 = m.addVar(name="search_engines", vtype=gp.GRB.INTEGER)  # Advertisements on search engines
x2 = m.addVar(name="videos", vtype=gp.GRB.INTEGER)      # Advertisements on videos
x3 = m.addVar(name="social_media", vtype=gp.GRB.INTEGER) # Advertisements on social media

# Objective: Maximize influence
m.setObjective(100000*x1 + 7000*x2 + 800*x3, gp.GRB.MAXIMIZE)

# Cost constraint
m.addConstr(50000*x1 + 5000*x2 + 1000*x3 <= 850000, name="budget_constraint")

# Video advertisements limit
m.addConstr(x2 <= 4, name="video_limit")

# Social media advertisements limit
m.addConstr(x3 <= 0.5*(x1 + x2 + x3), name="social_media_limit")

# Search engines advertisements requirement
m.addConstr(x1 >= 0.1*(x1 + x2 + x3), name="search_engines_requirement")

# Non-negativity constraints are inherently handled by defining variables as non-negative

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Advertisements on search engines: {x1.varValue}")
    print(f"Advertisements on videos: {x2.varValue}")
    print(f"Advertisements on social media: {x3.varValue}")
    print(f"Max Influence: {m.objVal}")
else:
    print("The model is infeasible")
