
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("chocolate_mixture")

# Create variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milk_chocolate")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dark_chocolate")

# Set objective function
model.setObjective(0.5 * x + 0.75 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * x + 4 * y >= 120, "cacao")
model.addConstr(2 * x + y >= 80, "sugar")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Milk chocolate pieces: {x.x:.2f}")
    print(f"Dark chocolate pieces: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

