
from gurobipy import *

# Create a new model
model = Model("Chocolate_Mixture")

# Define variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milk_chocolate")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dark_chocolate")

# Set the objective function
model.setObjective(0.50*x + 0.75*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3*x + 4*y >= 120, "cacao_constraint")
model.addConstr(2*x + y >= 80, "sugar_constraint")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milk Chocolate Pieces: {x.x}")
    print(f"Dark Chocolate Pieces: {y.x}")
    print(f"Total Cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
