
import gurobi as gp

# Create a new model
model = gp.Model("Chocolate_Mixture")

# Define the decision variables
M = model.addVar(lb=0, name="Milk_Chocolate_Pieces")
D = model.addVar(lb=0, name="Dark_Chocolate_Pieces")

# Objective function: Minimize cost
model.setObjective(0.50 * M + 0.75 * D, gp.GRB.MINIMIZE)

# Cacao constraint: 3M + 4D >= 120
model.addConstr(3 * M + 4 * D >= 120, name="Cacao_Constraint")

# Sugar constraint: 2M + D >= 80
model.addConstr(2 * M + D >= 80, name="Sugar_Constraint")

# Optimize the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milk Chocolate Pieces: {M.varValue}")
    print(f"Dark Chocolate Pieces: {D.varValue}")
    print(f"Total Cost: ${model.objVal:.2f}")
else:
    print("The model is infeasible or no solution exists.")
