
import gurobipy as gp

# Create a new model
model = gp.Model("SportsProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="shuttlecocks")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="volleyballs")

# Set objective function
model.setObjective(3.5 * x + 10 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * x + 20 * y <= 4000, "sewing_time")
model.addConstr(5 * x + 10 * y <= 3000, "quality_checking_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of shuttlecocks to produce: {x.x}")
    print(f"Number of volleyballs to produce: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

