
from gurobipy import *

# Create a model
m = Model("Sports_Company_Optimization")

# Decision variables: number of shuttlecocks (x) and volleyballs (y)
x = m.addVar(lb=0, name="shuttlecocks")
y = m.addVar(lb=0, name="volleyballs")

# Objective function: Maximize profit
m.setObjective(3.5*x + 10*y, GRB.MAXIMIZE)

# Constraints:
# Sewing time constraint
m.addConstr(15*x + 20*y <= 4000, "sewing_time")
# Quality checking time constraint
m.addConstr(5*x + 10*y <= 3000, "quality_checking")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x:.0f} shuttlecocks and {y.x:.0f} volleyballs.")
else:
    print("No optimal solution found. The problem might be infeasible.")

