
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x1 = model.addVar(lb=0, name="shuttlecocks")
x2 = model.addVar(lb=0, name="volleyballs")

# Define the objective function
model.setObjective(3.5 * x1 + 10 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * x1 + 20 * x2 <= 4000, name="sewing_time")
model.addConstr(5 * x1 + 10 * x2 <= 3000, name="quality_checking_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Shuttlecocks: {x1.varValue}")
    print(f"Volleyballs: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
