
import gurobipy as gp

# Create a new model
model = gp.Model("Glass Animals")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="dogs")  # Number of dogs
y = model.addVar(vtype=gp.GRB.INTEGER, name="cats")  # Number of cats

# Set objective function
model.setObjective(50*x + 40*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 1000, "heating")
model.addConstr(30*x + 20*y <= 1500, "molding")
model.addConstr(20*x + 15*y <= 1200, "cooling")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of dogs to make: {x.x}")
    print(f"Number of cats to make: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

