
from gurobipy import *

# Create a model
m = Model("Glass_Art")

# Decision variables
x_d = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="glass_dogs")
x_c = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="glass_cats")

# Objective function: Maximize profits
m.setObjective(50*x_d + 40*x_c, GRB.MAXIMIZE)

# Constraints
m.addConstr(10*x_d + 15*x_c <= 1000, "heating_constraint")
m.addConstr(30*x_d + 20*x_c <= 1500, "molding_constraint")
m.addConstr(20*x_d + 15*x_c <= 1200, "cooling_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of glass dogs: {x_d.x}")
    print(f"Number of glass cats: {x_c.x}")
    print(f"Maximum profit: ${50*x_d.x + 40*x_c.x:.2f}")
else:
    print("No optimal solution found")
