
import gurobi as gp

# Create a new model
model = gp.Model("glass_art")

# Define the variables
x = model.add_var(name="glass_dogs", lb=0, vtype=gp.GRB.INTEGER)
y = model.add_var(name="glass_cats", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.set_objective(gp.LinExpr(50 * x + 40 * y), gp.GRB.MAXIMIZE)

# Add constraints
model.add_constr(10 * x + 15 * y <= 1000, name="heating")
model.add_constr(30 * x + 20 * y <= 1500, name="molding")
model.add_constr(20 * x + 15 * y <= 1200, name="cooling")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
    print(f"Max Profit: ${50*x.varValue + 40*y.varValue}")
else:
    print("No optimal solution found")
