
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("PlantGrowthCompound")

# Create variables
x = m.addVar(lb=0, name="GreenCycle")
y = m.addVar(lb=0, name="GrowSafe")

# Set objective function
m.setObjective(1.5 * x + 1.8 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.1 * x + 3.5 * y >= 9, "NitrousOxide")
m.addConstr(1.3 * x + 1.1 * y >= 5, "VitaminMix")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Minimum Cost: ${m.objVal:.2f}")
    print(f"GreenCycle (kg): {x.x:.2f}")
    print(f"GrowSafe (kg): {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

