
from gurobipy import *

# Create a new model
m = Model("Plant_Growth_Compound")

# Define the variables
x1 = m.addVar(lb=0, name="GreenCycle")
x2 = m.addVar(lb=0, name="GrowSafe")

# Set the objective function
m.setObjective(1.5*x1 + 1.8*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.1*x1 + 3.5*x2 >= 9, "Nitrous_Oxide")
m.addConstr(1.3*x1 + 1.1*x2 >= 5, "Vitamin_Mix")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Minimum cost: $", m.objVal)
    print("GreenCycle (kg): ", x1.x)
    print("GrowSafe (kg): ", x2.x)
else:
    print("The model is infeasible")
