
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, name="GreenCycle")
    x2 = model.addVar(lb=0, name="GrowSafe")

    # Define the objective function
    model.setObjective(1.5 * x1 + 1.8 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2.1 * x1 + 3.5 * x2 >= 9, name="Nitrous_Oxide")
    model.addConstr(1.3 * x1 + 1.1 * x2 >= 5, name="Vitamin_Mix")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Minimum cost: ", model.objval)
        print("GreenCycle: ", x1.x)
        print("GrowSafe: ", x2.x)
    else:
        print("The model is infeasible")

solve_optimization_problem()
