
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PaintMixing")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Ruby")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Sapphire")

# Set objective function
model.setObjective(12*x + 15*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x + 4*y >= 15, "Dye")
model.addConstr(4*x + 6*y >= 20, "Thinner")
model.addConstr(5*x + 2*y >= 18, "Water")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Ruby Cans: {x.x}")
    print(f"Sapphire Cans: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

