
from gurobipy import *

# Create a model
m = Model("Paint_Mixture")

# Decision variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Ruby_Paint", lb=0)
S = m.addVar(vtype=GRB.CONTINUOUS, name="Sapphire_Paint", lb=0)

# Objective function: Minimize the total cost
m.setObjective(12*R + 15*S, GRB.MINIMIZE)

# Constraints
m.addConstr(2*R + 4*S >= 15, name="Dye_Constraint")
m.addConstr(4*R + 6*S >= 20, name="Thinner_Constraint")
m.addConstr(5*R + 2*S >= 18, name="Water_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ruby Paint: {R.x} cans")
    print(f"Sapphire Paint: {S.x} cans")
    print(f"Total Cost: ${12*R.x + 15*S.x}")
else:
    print("No optimal solution found.")
