
import gurobipy as gp

# Create a new model
model = gp.Model("paint_mixture")

# Define variables
R = model.addVar(name="Ruby", lb=0)  # Number of cans of Ruby paint
S = model.addVar(name="Sapphire", lb=0)  # Number of cans of Sapphire paint

# Objective function: Minimize cost
model.setObjective(12*R + 15*S, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(2*R + 4*S >= 15, name="Dye_Requirement")
model.addConstr(4*R + 6*S >= 20, name="Thinner_Requirement")
model.addConstr(5*R + 2*S >= 18, name="Water_Requirement")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Ruby: {R.varValue:.2f} cans")
    print(f"Sapphire: {S.varValue:.2f} cans")
else:
    print("No optimal solution found.")
