
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("DonutOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular_donuts") # Integer number of regular donuts
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="jelly_donuts") # Integer number of jelly donuts

# Set the objective function
model.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 1000, "donut_limit")
model.addConstr(4*x + 6*y <= 5000, "budget_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular donuts: {x.x}")
    print(f"Number of jelly-filled donuts: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

