
from gurobipy import *

# Create a new model
m = Model("donut_optimization")

# Define the decision variables
x_r = m.addVar(vtype=GRB.CONTINUOUS, name="regular_donuts")
x_j = m.addVar(vtype=GRB.CONTINUOUS, name="jelly_filled_donuts")

# Set the objective function to maximize profit
m.setObjective(2*x_r + 3*x_j, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_r + x_j <= 1000, "total_donuts")
m.addConstr(4*x_r + 6*x_j <= 5000, "budget")

# Solve the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular donuts: {x_r.x}")
    print(f"Jelly-filled donuts: {x_j.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
